/****************************************************************************
* Donohue and Wolfers (2006) 
* Figure 3
* Homicide Rates in the United States
****************************************************************************/

clear
cd "..."
use  "UCR 1960-2003.dta", clear
drop if st=="US"
rename murderandnonnegligentmanslaught murders
rename murderrate murdrate
egen stid=group(st)
tsset stid year

gen legal=1
replace legal=0 if st=="MI" & year>=1846
replace legal=0 if st=="RI" & year>=1852
replace legal=0 if st=="WI" & year>=1853
replace legal=0 if st=="IA" & year>=1872 & year<1878
replace legal=0 if st=="ME" & year>=1876 & year<1883
replace legal=0 if st=="ME" & year>=1887
replace legal=0 if st=="CO" & year>=1897 & year<1901
replace legal=0 if st=="KS" & year>=1907 & year<1935
replace legal=0 if st=="MN" & year>=1911
replace legal=0 if st=="WA" & year>=1913 & year<1919
replace legal=0 if st=="OR" & year>=1914 & year<1920
* replace legal=0 if st=="ND" & year>=1915
replace legal=0 if st=="SD" & year>=1915 & year<1939
replace legal=0 if st=="TN" & year>=1915 & year<1916
replace legal=0 if st=="AZ" & year>=1916 & year<1918
replace legal=0 if st=="MO" & year>=1917 & year<1919
replace legal=0 if st=="AK" & year>=1957
replace legal=0 if st=="HI" & year>=1957
replace legal=0 if st=="DE" & year>=1958 & year<1961
replace legal=0 if st=="OR" & year>=1964
replace legal=0 if st=="IA" & year>=1965
replace legal=0 if st=="WV" & year>=1965
replace legal=0 if st=="VT" & year>=1965
replace legal=0 if st=="NY" & year>=1965
replace legal=0 if st=="NM" & year>=1969
replace legal=0 if st=="NH" & year>=1972 /* Court decision */
replace legal=0 if st=="CA" & year>=1972 /* Court decision */
replace legal=0 if year>=1972
replace legal=1 if st=="RI" & year>=1977 & year<1984
replace legal=1 if st=="MA" & year>=1982 & year<1984
replace legal=1 if st=="AL" & year>=1976
replace legal=1 if st=="AZ" & year>=1973
replace legal=1 if st=="AR" & year>=1973
replace legal=1 if st=="CA" & year>=1977
replace legal=1 if st=="CO" & year>=1975
replace legal=1 if st=="CT" & year>=1973
replace legal=1 if st=="DE" & year>=1974
replace legal=1 if st=="FL" & year>=1972
replace legal=1 if st=="GA" & year>=1973
replace legal=1 if st=="ID" & year>=1973
replace legal=1 if st=="IL" & year>=1974
replace legal=1 if st=="IN" & year>=1973
replace legal=1 if st=="KS" & year>=1994
replace legal=1 if st=="KY" & year>=1975
replace legal=1 if st=="LA" & year>=1973
replace legal=1 if st=="MD" & year>=1975
replace legal=1 if st=="MS" & year>=1974
replace legal=1 if st=="MO" & year>=1975
replace legal=1 if st=="MT" & year>=1974
replace legal=1 if st=="NE" & year>=1973
replace legal=1 if st=="NV" & year>=1973
replace legal=1 if st=="NH" & year>=1991
replace legal=1 if st=="NJ" & year>=1982
replace legal=1 if st=="NM" & year>=1979
replace legal=1 if st=="NY" & year>=1995
replace legal=1 if st=="NC" & year>=1977
replace legal=1 if st=="OH" & year>=1974
replace legal=1 if st=="OK" & year>=1973
replace legal=1 if st=="OR" & year>=1978
replace legal=1 if st=="PA" & year>=1974
replace legal=1 if st=="SC" & year>=1974
replace legal=1 if st=="SD" & year>=1979
replace legal=1 if st=="TN" & year>=1974
replace legal=1 if st=="TX" & year>=1974
replace legal=1 if st=="UT" & year>=1973
replace legal=1 if st=="VA" & year>=1975
replace legal=1 if st=="WA" & year>=1975
replace legal=1 if st=="WY" & year>=1977
replace legal=0 if year>=1972 & year<1976

gen abolitionist=0
for any AK HI ME MI MN WI: replace abolitionist=1 if st=="X"
egen absmurds=sum(murders), by(abolitionist year)
egen abspop=sum(pop), by(abolitionist year)
gen absmurdrate=100000*absmurds/abspop
egen abstag=tag(abolitionist year)


twoway (line absmurdrate year if abolitionist==1, sort lcolor(red) lpattern(dash)) (line absmurdrate year if abolitionist==0, lcolor(blue) lwidth(medium)) if abstag==1 & year>=1960 & year<=2000, ytitle("Annual homicides per 100,000 residents") ylabel(0(3)12, angle(horizontal)) xtitle(Year) xmlabel(, tposition(inside) angle(vertical)) xline(1967 1972 1976, lwidth(thin) lcolor(black)) title(Homicide Rates in the United States) legend( rows(2) order(1 "Controls: Non-death penalty states" 2 "Treatment states (all others)")) legend(position(12)) text(3.5 1966.5 "Last execution until 1977", orientation(vertical)) text(6 1971.5 "Furman decision: Death penalty abolished", orientation(vertical)) text(5.9 1976.5 "Gregg decision: Death penalty re-instated", orientation(vertical)) note("Non-death penalty states are those without a death penalty throughout 1960-2000: AK HI ME MI MN WI") xsize(10) ysize(7.5)
